<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    public function up(): void
    {
        Schema::create('amazon_financial_safet_reimbursement_items', function (Blueprint $table) {
            $table->id();
            $table->foreignId('amazon_financial_safet_reimbursement_event_id')->constrained()->index('afsr_parent_index');
            $table->string('productDescription')->storedAs('json_extract(json_object, "$.productDescription")');
            $table->string('quantity')->storedAs('json_extract(json_object, "$.quantity")');
            $table->json('json_object');
            $table->timestamps();
        });
    }

    public function down(): void
    {
        Schema::dropIfExists('amazon_financial_safet_reimbursement_items');
    }
};
