<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    public function up(): void
    {
        Schema::create('amazon_financial_removal_shipment_items', function (Blueprint $table) {
            $table->id();
            $table->foreignId('amazon_financial_removal_shipment_event_id')->constrained()->index('afrs_parent_index');
            $table->string('RemovalShipmentItemId')->storedAs('json_extract(json_object, "$.RemovalShipmentItemId")');
            $table->string('TaxCollectionModel')->storedAs('json_extract(json_object, "$.TaxCollectionModel")');
            $table->string('FulfillmentNetworkSKU')->storedAs('json_extract(json_object, "$.FulfillmentNetworkSKU")');
            $table->integer('Quantity')->storedAs('json_extract(json_object, "$.Quantity")');
            $table->decimal('RevenueCurrencyAmount', 10, 2)->storedAs('json_extract(json_object, "$.Revenue.CurrencyAmount")');
            $table->string('RevenueCurrencyCode')->storedAs('json_extract(json_object, "$.Revenue.CurrencyCode")');
            $table->decimal('FeeCurrencyAmount', 10, 2)->storedAs('json_extract(json_object, "$.FeeAmount.CurrencyAmount")');
            $table->string('FeeCurrencyCode')->storedAs('json_extract(json_object, "$.FeeAmount.CurrencyCode")');
            $table->decimal('TaxCurrencyAmount', 10, 2)->storedAs('json_extract(json_object, "$.TaxAmount.CurrencyAmount")');
            $table->string('TaxCurrencyCode')->storedAs('json_extract(json_object, "$.TaxAmount.CurrencyCode")');
            $table->decimal('TaxWithheldCurrencyAmount', 10, 2)->storedAs('json_extract(json_object, "$.TaxWithheld.CurrencyAmount")');
            $table->string('TaxWithheldCurrencyCode')->storedAs('json_extract(json_object, "$.TaxWithheld.CurrencyCode")');
            $table->json('json_object');
            $table->timestamps();
        });
    }

    public function down(): void
    {
        Schema::dropIfExists('amazon_financial_removal_shipment_items');
    }
};
