<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    public function up(): void
    {
        Schema::create('amazon_financial_debt_recovery_items', function (Blueprint $table) {
            $table->id();
            $table->foreignId('amazon_financial_debt_recovery_event_id')->constrained()->index('afdr_parent_index');
            $table->decimal('RecoveryCurrencyAmount', 10, 2)->storedAs('json_extract(json_object, "$.RecoveryAmount.CurrencyAmount")');
            $table->string('RecoveryCurrencyCode')->storedAs('json_extract(json_object, "$.RecoveryAmount.CurrencyCode")');
            $table->decimal('OriginalCurrencyAmount', 10, 2)->storedAs('json_extract(json_object, "$.OriginalAmount.CurrencyAmount")');
            $table->string('OriginalCurrencyCode')->storedAs('json_extract(json_object, "$.OriginalAmount.CurrencyCode")');
            $table->string('GroupBeginDate')->storedAs('json_extract(json_object, "$.GroupBeginDate")');
            $table->string('GroupEndDate')->nullable()->storedAs('json_extract(json_object, "$.GroupEndDate")');
            $table->json('json_object');
            $table->timestamps();
        });
    }

    public function down(): void
    {
        Schema::dropIfExists('amazon_financial_debt_recovery_items');
    }
};
