<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    public function up(): void
    {
        Schema::create('amazon_financial_charge_refund_transactions', function (Blueprint $table) {
            $table->id();
            $table->foreignId('amazon_financial_charge_refund_event_id')->constrained()->index('afcr_parent_index');
            $table->decimal('CurrencyAmount', 10, 2)->storedAs('json_extract(json_object, "$.ChargeAmount.CurrencyAmount")');
            $table->string('CurrencyCode')->storedAs('json_extract(json_object, "$.ChargeAmount.CurrencyCode")');
            $table->string('ChargeType')->storedAs('json_extract(json_object, "$.ChargeType")');
            $table->json('json_object');
            $table->timestamps();
        });
    }

    public function down(): void
    {
        Schema::dropIfExists('amazon_financial_charge_refund_transactions');
    }
};
