<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    public function up(): void
    {
        Schema::create('amazon_financial_trial_shipment_events', function (Blueprint $table) {
            $table->id();
            $table->foreignId('integration_instance_id')->constrained()->index('aftse_integration_instance_id_index');
            $table->foreignId('amazon_financial_event_group_id')->constrained()->index('aftse_amazon_financial_event_group_index');
            $table->string('AmazonOrderId')->storedAs('json_extract(json_object, "$.AmazonOrderId")');
            $table->string('FinancialEventGroupId')->storedAs('json_extract(json_object, "$.FinancialEventGroupId")');
            $table->string('PostedDate')->storedAs('json_extract(json_object, "$.PostedDate")');
            $table->string('SKU')->storedAs('json_extract(json_object, "$.SKU")');
            $table->json('json_object');
            $table->timestamps();
        });
    }

    public function down(): void
    {
        Schema::dropIfExists('amazon_financial_trial_shipment_events');
    }
};
