<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    public function up(): void
    {
        Schema::create('amazon_financial_tds_reimbursement_events', function (Blueprint $table) {
            $table->id();
            $table->foreignId('integration_instance_id')->constrained()->index('aftre_integration_instance_id_index');
            $table->foreignId('amazon_financial_event_group_id')->constrained()->index('aftre_amazon_financial_event_group_index');
            $table->string('PostedDate')->storedAs('json_extract(json_object, "$.PostedDate")');
            $table->string('TDSOrderId')->storedAs('json_extract(json_object, "$.TDSOrderId")');
            $table->decimal('CurrencyAmount', 10, 2)->storedAs('json_extract(json_object, "$.ReimbursedAmount.CurrencyAmount")');
            $table->string('CurrencyCode')->storedAs('json_extract(json_object, "$.ReimbursedAmount.CurrencyCode")');
            $table->json('json_object');
            $table->timestamps();
        });
    }

    public function down(): void
    {
        Schema::dropIfExists('amazon_financial_tds_reimbursement_events');
    }
};
