<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    public function up(): void
    {
        Schema::create('amazon_financial_solution_provider_credit_events', function (Blueprint $table) {
            $table->id();
            $table->foreignId('integration_instance_id')->constrained()->index('afspce_integration_instance_id_index');
            $table->foreignId('amazon_financial_event_group_id')->constrained()->index('afspce_amazon_financial_event_group_index');
            $table->string('ProviderTransactionType')->storedAs('json_extract(json_object, "$.ProviderTransactionType")');
            $table->string('SellerOrderId')->storedAs('json_extract(json_object, "$.SellerOrderId")');
            $table->string('MarketplaceId')->storedAs('json_extract(json_object, "$.MarketplaceId")');
            $table->string('MarketplaceCountryCode')->storedAs('json_extract(json_object, "$.MarketplaceCountryCode")');
            $table->string('SellerId')->storedAs('json_extract(json_object, "$.SellerId")');
            $table->string('SellerStoreName')->storedAs('json_extract(json_object, "$.SellerStoreName")');
            $table->string('ProviderId')->storedAs('json_extract(json_object, "$.ProviderId")');
            $table->string('ProviderStoreName')->storedAs('json_extract(json_object, "$.ProviderStoreName")');
            $table->decimal('CurrencyAmount', 10, 2)->storedAs('json_extract(json_object, "$.TransactionAmount.CurrencyAmount")');
            $table->string('CurrencyCode')->storedAs('json_extract(json_object, "$.TransactionAmount.CurrencyCode")');
            $table->string('TransactionCreationDate')->storedAs('json_extract(json_object, "$.TransactionCreationDate")');
            $table->json('json_object');
            $table->timestamps();
        });
    }

    public function down(): void
    {
        Schema::dropIfExists('amazon_financial_solution_provider_credit_events');
    }
};
