<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    public function up(): void
    {
        Schema::create('amazon_financial_retrocharge_events', function (Blueprint $table) {
            $table->id();
            $table->foreignId('integration_instance_id')->constrained()->index('afret_integration_instance_id_index');
            $table->foreignId('amazon_financial_event_group_id')->constrained()->index('afret_amazon_financial_event_group_index');
            $table->string('RetrochargeEventType')->storedAs('json_extract(json_object, "$.RetrochargeEventType")');
            $table->string('AmazonOrderId')->storedAs('json_extract(json_object, "$.AmazonOrderId")');
            $table->string('PostedDate')->storedAs('json_extract(json_object, "$.PostedDate")');
            $table->decimal('BaseTaxCurrencyAmount', 10, 2)->storedAs('json_extract(json_object, "$.BaseTax.CurrencyAmount")');
            $table->string('BaseTaxCurrencyCode')->storedAs('json_extract(json_object, "$.BaseTax.CurrencyCode")');
            $table->decimal('ShippingTaxCurrencyAmount', 10, 2)->storedAs('json_extract(json_object, "$.ShippingTax.CurrencyAmount")');
            $table->string('ShippingTaxCurrencyCode')->storedAs('json_extract(json_object, "$.ShippingTax.CurrencyCode")');
            $table->string('MarketplaceName')->storedAs('json_extract(json_object, "$.MarketplaceName")');
            $table->json('json_object');
            $table->timestamps();
        });
    }

    public function down(): void
    {
        Schema::dropIfExists('amazon_financial_retrocharge_events');
    }
};
