<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    public function up(): void
    {
        Schema::create('amazon_financial_rental_transaction_events', function (Blueprint $table) {
            $table->id();
            $table->foreignId('integration_instance_id')->constrained()->index('afrte_integration_instance_id_index');
            $table->foreignId('amazon_financial_event_group_id')->constrained()->index('afrte_amazon_financial_event_group_index');
            $table->string('AmazonOrderId')->storedAs('json_extract(json_object, "$.AmazonOrderId")');
            $table->string('RentalEventType')->storedAs('json_extract(json_object, "$.RentalEventType")');
            $table->string('ExtensionLength')->storedAs('json_extract(json_object, "$.ExtensionLength")');
            $table->string('PostedDate')->storedAs('json_extract(json_object, "$.PostedDate")');
            $table->string('MarketplaceName')->storedAs('json_extract(json_object, "$.MarketplaceName")');
            $table->decimal('RentalInitialValueCurrencyAmount', 10, 2)->storedAs('json_extract(json_object, "$.RentalInitialValue.CurrencyAmount")');
            $table->string('RentalInitialValueCurrencyCode')->storedAs('json_extract(json_object, "$.RentalInitialValue.CurrencyCode")');
            $table->decimal('RentalReimbursementCurrencyAmount', 10, 2)->storedAs('json_extract(json_object, "$.RentalReimbursement.CurrencyAmount")');
            $table->string('RentalReimbursementCurrencyCode')->storedAs('json_extract(json_object, "$.RentalReimbursement.CurrencyCode")');
            $table->json('json_object');
            $table->timestamps();
        });
    }

    public function down(): void
    {
        Schema::dropIfExists('amazon_financial_rental_transaction_events');
    }
};
