<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    public function up(): void
    {
        Schema::create('amazon_financial_product_ad_payment_events', function (Blueprint $table) {
            $table->id();
            $table->foreignId('integration_instance_id')->constrained()->index('afpape_integration_instance_id_index');
            $table->foreignId('amazon_financial_event_group_id')->constrained()->index('afpape_amazon_financial_event_group_index');
            $table->string('postedDate')->storedAs('json_extract(json_object, "$.postedDate")');
            $table->string('transactionType')->storedAs('json_extract(json_object, "$.transactionType")');
            $table->string('invoiceId')->storedAs('json_extract(json_object, "$.invoiceId")');
            $table->decimal('baseValueCurrencyAmount', 10, 2)->storedAs('json_extract(json_object, "$.baseValue.CurrencyAmount")');
            $table->string('baseValueCurrencyCode')->storedAs('json_extract(json_object, "$.baseValue.CurrencyCode")');
            $table->decimal('taxValueCurrencyAmount', 10, 2)->storedAs('json_extract(json_object, "$.taxValue.CurrencyAmount")');
            $table->string('taxValueCurrencyCode')->storedAs('json_extract(json_object, "$.taxValue.CurrencyCode")');
            $table->decimal('transactionValueCurrencyAmount', 10, 2)->storedAs('json_extract(json_object, "$.transactionValue.CurrencyAmount")');
            $table->string('transactionValueCurrencyCode')->storedAs('json_extract(json_object, "$.transactionValue.CurrencyCode")');
            $table->json('json_object');
            $table->timestamps();
        });
    }

    public function down(): void
    {
        Schema::dropIfExists('amazon_financial_product_ad_payment_events');
    }
};
