<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    public function up(): void
    {
        Schema::create('amazon_financial_pay_with_amazon_events', function (Blueprint $table) {
            $table->id();
            $table->foreignId('integration_instance_id')->constrained()->index('afpwae_integration_instance_id_index');
            $table->foreignId('amazon_financial_event_group_id')->constrained()->index('afpwae_amazon_financial_event_group_index');
            $table->string('SellerOrderId')->storedAs('json_extract(json_object, "$.SellerOrderId")');
            $table->string('TransactionPostedDate')->storedAs('json_extract(json_object, "$.TransactionPostedDate")');
            $table->string('BusinessObjectType')->storedAs('json_extract(json_object, "$.BusinessObjectType")');
            $table->string('SalesChannel')->storedAs('json_extract(json_object, "$.SalesChannel")');
            $table->string('PaymentAmountType')->storedAs('json_extract(json_object, "$.PaymentAmountType")');
            $table->string('AmountDescription')->storedAs('json_extract(json_object, "$.AmountDescription")');
            $table->string('FulfillmentChannel')->storedAs('json_extract(json_object, "$.FulfillmentChannel")');
            $table->string('StoreName')->storedAs('json_extract(json_object, "$.StoreName")');
            $table->json('json_object');
            $table->timestamps();
        });
    }

    public function down(): void
    {
        Schema::dropIfExists('amazon_financial_pay_with_amazon_events');
    }
};
