<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    public function up(): void
    {
        Schema::create('amazon_financial_imaging_services_fee_events', function (Blueprint $table) {
            $table->id();
            $table->foreignId('integration_instance_id')->constrained()->index('afisfe_integration_instance_id_index');
            $table->foreignId('amazon_financial_event_group_id')->constrained()->index('afisfe_amazon_financial_event_group_index');
            $table->string('ImagingRequestBillingItemID')->storedAs('json_extract(json_object, "$.ImagingRequestBillingItemID")');
            $table->string('ASIN')->storedAs('json_extract(json_object, "$.ASIN")');
            $table->string('PostedDate')->storedAs('json_extract(json_object, "$.PostedDate")');
            $table->json('json_object');
            $table->timestamps();
        });
    }

    public function down(): void
    {
        Schema::dropIfExists('amazon_financial_imaging_services_fee_events');
    }
};
