<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    public function up(): void
    {
        Schema::create('amazon_financial_failed_adhoc_disbursement_events', function (Blueprint $table) {
            $table->id();
            $table->foreignId('integration_instance_id')->constrained()->index('affade_integration_instance_id_index');
            $table->foreignId('amazon_financial_event_group_id')->constrained()->index('affade_amazon_financial_event_group_index');
            $table->string('FundsTransfersType')->storedAs('json_extract(json_object, "$.FundsTransfersType")');
            $table->string('TransferId')->storedAs('json_extract(json_object, "$.TransferId")');
            $table->string('DisbursementId')->storedAs('json_extract(json_object, "$.DisbursementId")');
            $table->string('PaymentDisbursementType')->storedAs('json_extract(json_object, "$.PaymentDisbursementType")');
            $table->string('Status')->storedAs('json_extract(json_object, "$.Status")');
            $table->decimal('CurrencyAmount', 10, 2)->storedAs('json_extract(json_object, "$.TransferAmount.CurrencyAmount")');
            $table->string('CurrencyCode')->storedAs('json_extract(json_object, "$.TransferAmount.CurrencyCode")');
            $table->string('PostedDate')->storedAs('json_extract(json_object, "$.PostedDate")');
            $table->json('json_object');
            $table->timestamps();
        });
    }

    public function down(): void
    {
        Schema::dropIfExists('amazon_financial_failed_adhoc_disbursement_events');
    }
};
