<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    public function up(): void
    {
        Schema::create('amazon_financial_coupon_payment_events', function (Blueprint $table) {
            $table->id();
            $table->foreignId('integration_instance_id')->constrained()->index('afcpe_integration_instance_id_index');
            $table->foreignId('amazon_financial_event_group_id')->constrained()->index('afcpe_amazon_financial_event_group_index');
            $table->string('PostedDate')->storedAs('json_extract(json_object, "$.PostedDate")');
            $table->string('CouponId')->storedAs('json_extract(json_object, "$.CouponId")');
            $table->string('SellerCouponDescription')->storedAs('json_extract(json_object, "$.SellerCouponDescription")');
            $table->integer('ClipOrRedemptionCount')->storedAs('json_extract(json_object, "$.ClipOrRedemptionCount")');
            $table->string('PaymentEventId')->storedAs('json_extract(json_object, "$.PaymentEventId")');
            $table->decimal('CurrencyAmount', 10, 2)->storedAs('json_extract(json_object, "$.TotalAmount.CurrencyAmount")');
            $table->string('CurrencyCode')->storedAs('json_extract(json_object, "$.TotalAmount.CurrencyCode")');
            $table->json('json_object');
            $table->timestamps();
        });
    }

    public function down(): void
    {
        Schema::dropIfExists('amazon_financial_coupon_payment_events');
    }
};
