<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    public function up(): void
    {
        Schema::create('amazon_financial_affordability_expense_events', function (Blueprint $table) {
            $table->id();
            $table->foreignId('integration_instance_id')->constrained()->index('afaeet_integration_instance_id_index');
            $table->foreignId('amazon_financial_event_group_id')->constrained()->index('afaeet_amazon_financial_event_group_index');
            $table->string('AmazonOrderId')->storedAs('json_extract(json_object, "$.AmazonOrderId")');
            $table->string('PostedDate')->storedAs('json_extract(json_object, "$.PostedDate")');
            $table->string('MarketplaceId')->storedAs('json_extract(json_object, "$.MarketplaceId")');
            $table->string('TransactionType')->storedAs('json_extract(json_object, "$.TransactionType")');
            $table->decimal('BaseExpenseCurrencyAmount', 10, 2)->storedAs('json_extract(json_object, "$.BaseExpense.CurrencyAmount")');
            $table->string('BaseExpenseCurrencyCode')->storedAs('json_extract(json_object, "$.BaseExpense.CurrencyCode")');
            $table->decimal('TaxTypeCGSTCurrencyAmount', 10, 2)->storedAs('json_extract(json_object, "$.TaxTypeCGST.CurrencyAmount")');
            $table->string('TaxTypeCGSTCurrencyCode')->storedAs('json_extract(json_object, "$.TaxTypeCGST.CurrencyCode")');
            $table->decimal('TaxTypeSGSTCurrencyAmount', 10, 2)->storedAs('json_extract(json_object, "$.TaxTypeSGST.CurrencyAmount")');
            $table->string('TaxTypeSGSTCurrencyCode')->storedAs('json_extract(json_object, "$.TaxTypeSGST.CurrencyCode")');
            $table->decimal('TaxTypeIGSTCurrencyAmount', 10, 2)->storedAs('json_extract(json_object, "$.TaxTypeIGST.CurrencyAmount")');
            $table->string('TaxTypeIGSTCurrencyCode')->storedAs('json_extract(json_object, "$.TaxTypeIGST.CurrencyCode")');
            $table->decimal('TotalExpenseCurrencyAmount', 10, 2)->storedAs('json_extract(json_object, "$.TotalExpense.CurrencyAmount")');
            $table->string('TotalExpenseCurrencyCode')->storedAs('json_extract(json_object, "$.TotalExpense.CurrencyCode")');
            $table->json('json_object');
            $table->timestamps();
        });
    }

    public function down(): void
    {
        Schema::dropIfExists('amazon_financial_affordability_expense_events');
    }
};
