<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    public function up(): void
    {
        Schema::create('amazon_financial_events', function (Blueprint $table) {
            $table->id();
            $table->foreignId('integration_instance_id')->constrained()->index('integration_instance_id_index');
            $table->foreignId('amazon_financial_event_group_id')->constrained()->index('amazon_financial_event_group_index');
            $table->string('event_type');
            $table->boolean('is_processed')->default(0);
            $table->json('json_object');
            $table->timestamps();
        });
    }

    public function down(): void
    {
        Schema::dropIfExists('amazon_financial_events');
    }
};
