<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration {
    public function up(): void
    {
        Schema::table('amazon_fba_inbound_shipment_items', function (Blueprint $table) {
            $table->foreign('amazon_fba_inbound_shipment_id', 'amazon_fba_inbound_shipment_items_inbound_shipment_id_foreign')->references('id')->on('amazon_fba_inbound_shipments')->onDelete('restrict');
        });
    }

    public function down(): void
    {
        Schema::table('amazon_fba_inbound_shipment_items', function (Blueprint $table) {
            $table->dropForeign('amazon_fba_inbound_shipment_items_inbound_shipment_id_foreign');
        });
    }
};
