<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration {
    public function up(): void
    {
        // Delete duplicates
        DB::statement('DELETE a
FROM amazon_fulfillment_order_items a
LEFT JOIN (
    SELECT MAX(id) as id
    FROM amazon_fulfillment_order_items
    GROUP BY amazon_fulfillment_order_id, sellerFulfillmentOrderItemId
) b ON a.id = b.id
WHERE b.id IS NULL;');

        Schema::table('amazon_fulfillment_order_items', function (Blueprint $table) {
            $table->unique(['amazon_fulfillment_order_id', 'sellerFulfillmentOrderItemId'], 'amazon_fulfillment_order_items_unique_idx');
        });
    }
};
