<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration {
    public function up(): void
    {
        Schema::dropIfExists('amazon_ledger_summary_adjustments');

        Schema::create('amazon_ledger_summary_adjustments', function (Blueprint $table) {
            $table->id();
            $table->unsignedBigInteger('amazon_fba_report_inventory_ledger_summary_id');
            $table->string('type');
            $table->unsignedBigInteger('inventory_adjustment_id');
            $table->timestamps();
            $table->foreign('amazon_fba_report_inventory_ledger_summary_id', 'ledger_summary_adjustment_summary_id_foreign')
                ->references('id')
                ->on('amazon_fba_report_inventory_ledger_summaries')
                ->onDelete('cascade');
            $table->foreign('inventory_adjustment_id', 'ledger_summary_adjustment_inventory_adjustment_id_foreign')
                ->references('id')
                ->on('inventory_adjustments')
                ->onDelete('cascade');
            $table->unique(['amazon_fba_report_inventory_ledger_summary_id', 'inventory_adjustment_id'], 'unique_adjustment');
        });
    }

    public function down(): void
    {
        // Not implemented
    }
};
