<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration {
    public function up(): void
    {
        Schema::table('amazon_fnsku_products', function (Blueprint $table) {
            $table->integer('reconciled_quantity')->default(0)->after('product_id');
            $table->integer('reconciled_in_transit_quantity')->default(0)->after('reconciled_quantity');
        });
    }

    public function down(): void
    {
        Schema::table('amazon_fnsku_products', function (Blueprint $table) {
            $table->dropColumn('reconciled_quantity');
            $table->dropColumn('reconciled_in_transit_quantity');
        });
    }
};