<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration {
    public function up(): void
    {
        Schema::create('amazon_transfer_receipt_groups', function (Blueprint $table) {
            $table->id();
            $table->unsignedBigInteger('amazon_fba_report_inventory_ledger_id');
            $table->foreign('amazon_fba_report_inventory_ledger_id', 'atrg_fk')
                ->references('id')
                ->on('amazon_fba_report_inventory_ledger')
                ->onDelete('restrict');
            $table->unique('amazon_fba_report_inventory_ledger_id', 'amazon_transfer_receipt_groups_unique_idx');
            $table->timestamps();
        });
    }

    public function down(): void
    {
        Schema::dropIfExists('amazon_transfer_receipt_group');
    }
};
