<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration {
    public function up(): void
    {
        Schema::table('amazon_fba_initial_inventory', function (Blueprint $table) {
            $table->unsignedBigInteger('in_transit_warehouse_transfer_shipment_line_id')->nullable()->after('fifo_layer_id');
            $table->foreign('in_transit_warehouse_transfer_shipment_line_id', 'shipment_line_id_foreign')->references('id')->on('warehouse_transfer_shipment_lines')->restrictOnDelete();
        });
    }

    public function down(): void
    {
        Schema::table('amazon_fba_initial_inventory', function (Blueprint $table) {
            $table->dropForeign('shipment_line_id_foreign');
            $table->dropColumn('in_transit_warehouse_transfer_shipment_line_id');
        });
    }
};
