<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration {
    public function up(): void
    {
        Schema::table('amazon_fba_report_inventory_ledger', function (Blueprint $table) {
            $table->dateTime('last_reconciliation_attempted_at')->nullable()->after('json_object');
            $table->renameColumn('last_processed_at', 'reconciled_at');
            $table->renameColumn('auditTrailError', 'errorLog');
        });
    }

    public function down(): void
    {
        Schema::table('amazon_fba_report_inventory_ledger', function (Blueprint $table) {
            $table->dropColumn('last_reconciliation_attempted_at');
            $table->renameColumn('reconciled_at', 'last_processed_at');
            $table->renameColumn('errorLog', 'auditTrailError');
        });
    }
};
