<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration {
    public function up(): void
    {
        Schema::create('amazon_fba_inbound_ship_from_mappings', function (Blueprint $table) {
            $table->id();
            $table->foreignId('integration_instance_id')->index('integration_instance_id_index')->constrained('integration_instances', 'id', 'foreign_integration_instance_id');
            $table->string('name');
            $table->unsignedBigInteger('link_id')->nullable();
            $table->string('link_type')->nullable();
            $table->timestamps();
            $table->unique(['integration_instance_id', 'name'], 'inbound_ship_from_mappings_unique_idx');
        });
    }

    public function down(): void
    {
        Schema::dropIfExists('amazon_fba_inbound_ship_from_mappings');
    }
};
