<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    public function up(): void
    {
        Schema::table('amazon_feed_submissions', function (Blueprint $table) {
            $table->json('metadata')->nullable()->after('compressionAlgorithm');
            $table->text('url')->change();
        });
    }

    public function down(): void
    {
        Schema::table('amazon_feed_submissions', function (Blueprint $table) {
            $table->dropColumn('metadata');
            $table->string('url')->change();
        });
    }
};
