<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     */
    public function up(): void
    {
        Schema::table('amazon_fba_inbound_shipments', function (Blueprint $table) {
            $table->boolean('is_before_initial_count')->default(false)->after('sku_link_type');
        });
    }

    /**
     * Reverse the migrations.
     */
    public function down(): void
    {
        Schema::table('amazon_fba_inbound_shipments', function (Blueprint $table) {
            $table->dropColumn('is_before_initial_count');
        });
    }
};
