<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     */
    public function up(): void
    {
        Schema::table('amazon_fnsku_products', function (Blueprint $table) {
            $table->dropForeign('amazon_fnsku_products_integration_instance_id_foreign');
            $table->dropIndex('PRIMARY');
        });
        Schema::table('amazon_fnsku_products', function (Blueprint $table) {
            $table->id()->first();
            $table->unique(['integration_instance_id', 'fnsku']);
            $table->foreign('integration_instance_id', 'amazon_fnsku_products_integration_instance_id_foreign')->references('id')->on('integration_instances')->onDelete('restrict')->onUpdate('restrict');
        });
    }

    /**
     * Reverse the migrations.
     */
    public function down(): void
    {
        Schema::table('amazon_fnsku_products', function (Blueprint $table) {
            $table->dropColumn('id');
            $table->primary(['integration_instance_id', 'fnsku']);
        });
    }
};
