<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     */
    public function up(): void
    {
        Schema::table('amazon_fba_report_inventory_ledger', function (Blueprint $table) {
            $table->index(['integration_instance_id', 'fnsku'], 'amazon_fba_report_inventory_ledger_fnsku_index');
        });
        Schema::table('amazon_fba_report_inventory_ledger_summaries', function (Blueprint $table) {
            $table->index(['integration_instance_id', 'fnsku'], 'amazon_fba_report_inventory_ledger_summaries_fnsku_index');
        });
    }

    /**
     * Reverse the migrations.
     */
    public function down(): void
    {
        Schema::table(
            'amazon_fba_report_inventory_ledger',
            function (Blueprint $table) {
                $table->dropIndex('amazon_fba_report_inventory_ledger_fnsku_index');
            }
        );
        Schema::table(
            'amazon_fba_report_inventory_ledger_summaries',
            function (Blueprint $table) {
                $table->dropIndex('amazon_fba_report_inventory_ledger_summaries_fnsku_index');
            }
        );
    }
};
