<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     */
    public function up(): void
    {
        Schema::create('amazon_fnsku_products', function (Blueprint $table) {
            $table->foreignId('integration_instance_id')->constrained('integration_instances');
            $table->string('fnsku');
            $table->foreignId('product_id')->index()->constrained('products');
            $table->datetime('fba_initialized_at')->nullable();
            $table->timestamps();
            $table->primary(['integration_instance_id', 'fnsku'], 'amazon_fnsku_primary');

        });
    }

    /**
     * Reverse the migrations.
     */
    public function down(): void
    {
        Schema::dropIfExists('amazon_fnsku_products');
    }
};
