<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     */
    public function up(): void
    {
        Schema::table('amazon_report_settlement_type_mappings', function (Blueprint $table) {
            $table->string('financial_code')->storedAs('CONCAT(transaction_type, ": ", amount_type, " - ", amount_description)')->after('amount_description');
            $table->unique(['integration_instance_id', 'financial_code'], 'financial_code_unique');
        });
    }

    /**
     * Reverse the migrations.
     */
    public function down(): void
    {
        Schema::table('amazon_report_settlement_type_mappings', function (Blueprint $table) {
            $table->dropUnique('financial_code_unique');
            $table->dropColumn('financial_code');
        });
    }
};
