<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     */
    public function up(): void
    {
        Schema::create('amazon_report_settlement_type_mappings', function (Blueprint $table) {
            $table->id();
            $table->foreignId('integration_instance_id')->constrained()->index('arstm_findex_integration_instance_id');
            $table->string('transaction_type');
            $table->string('amount_type');
            $table->string('amount_description');
            $table->foreignId('nominal_code_id')->nullable()->constrained()->index('nominal_code_id');
            $table->unique(['integration_instance_id', 'transaction_type', 'amount_type', 'amount_description'], 'composite_unique');
            $table->timestamps();
        });
    }

    /**
     * Reverse the migrations.
     */
    public function down(): void
    {
        Schema::dropIfExists('amazon_report_settlement_types');
    }
};
