<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     */
    public function up(): void
    {
        Schema::table('amazon_products', function (Blueprint $table) {
            $table->dropColumn('quantity');
        });

        Schema::table('amazon_products', function (Blueprint $table) {
            $table->string('quantity')->storedAs('JSON_UNQUOTE(JSON_EXTRACT(json_object, "$.quantity"))')->after('price');
        });
    }

    /**
     * Reverse the migrations.
     */
    public function down(): void
    {
        Schema::table('amazon_products', function (Blueprint $table) {
            $table->dropColumn('quantity');
        });

        Schema::table('amazon_products', function (Blueprint $table) {
            $table->unsignedInteger('quantity')->storedAs('JSON_UNQUOTE(JSON_EXTRACT(json_object, "$.quantity"))')->after('price');
        });
    }
};
