<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     */
    public function up(): void
    {
        Schema::create('amazon_report_settlement_data', function (Blueprint $table) {
            $table->id();
            $table->foreignId('integration_instance_id')->index()->constrained();
            $table->foreignId('amazon_report_id')->index()->constrained();
            $table->foreignId('amazon_financial_event_group_id')->constrained()->index('afeg_findex')
                ->storedAs("JSON_UNQUOTE(JSON_EXTRACT(json_object, '$.amazon_financial_event_group_id'))");
            $table->string('settlement_id')->storedAs("JSON_UNQUOTE(JSON_EXTRACT(json_object, '$.settlement_id'))");
            $table->string('transaction_type')->storedAs("JSON_UNQUOTE(JSON_EXTRACT(json_object, '$.transaction_type'))");
            $table->string('order_id')->storedAs("JSON_UNQUOTE(JSON_EXTRACT(json_object, '$.order_id'))");
            $table->string('merchant_order_id')->storedAs("JSON_UNQUOTE(JSON_EXTRACT(json_object, '$.merchant_order_id'))");
            $table->string('adjustment_id')->storedAs("JSON_UNQUOTE(JSON_EXTRACT(json_object, '$.adjustment_id'))");
            $table->string('shipment_id')->storedAs("JSON_UNQUOTE(JSON_EXTRACT(json_object, '$.shipment_id'))");
            $table->string('marketplace_name')->storedAs("JSON_UNQUOTE(JSON_EXTRACT(json_object, '$.marketplace_name'))");
            $table->string('amount_type')->storedAs("JSON_UNQUOTE(JSON_EXTRACT(json_object, '$.amount_type'))");
            $table->string('amount_description')->storedAs("JSON_UNQUOTE(JSON_EXTRACT(json_object, '$.amount_description'))");
            $table->string('amount')->storedAs("JSON_UNQUOTE(JSON_EXTRACT(json_object, '$.amount'))");
            $table->string('fulfillment_id')->storedAs("JSON_UNQUOTE(JSON_EXTRACT(json_object, '$.fulfillment_id'))");
            $table->string('posted_date')->storedAs("JSON_UNQUOTE(JSON_EXTRACT(json_object, '$.posted_date'))");
            $table->string('posted_date_time')->storedAs("JSON_UNQUOTE(JSON_EXTRACT(json_object, '$.posted_date_time'))");
            $table->string('order_item_code')->storedAs("JSON_UNQUOTE(JSON_EXTRACT(json_object, '$.order_item_code'))");
            $table->string('merchant_order_item_id')->storedAs("JSON_UNQUOTE(JSON_EXTRACT(json_object, '$.merchant_order_item_id'))");
            $table->string('merchant_adjustment_item_id')->storedAs("JSON_UNQUOTE(JSON_EXTRACT(json_object, '$.merchant_adjustment_item_id'))");
            $table->string('sku')->storedAs("JSON_UNQUOTE(JSON_EXTRACT(json_object, '$.sku'))");
            $table->string('quantity_purchased')->storedAs("JSON_UNQUOTE(JSON_EXTRACT(json_object, '$.quantity_purchased'))");
            $table->string('promotion_id')->storedAs("JSON_UNQUOTE(JSON_EXTRACT(json_object, '$.promotion_id'))");
            $table->json('json_object');
            $table->timestamps();
        });
    }

    /**
     * Reverse the migrations.
     */
    public function down(): void
    {
        Schema::dropIfExists('amazon_report_settlement_data');
    }
};
