<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     */
    public function up(): void
    {
        Schema::table('amazon_fba_report_inventory', function (Blueprint $table) {
            $table->foreignId('amazon_report_id')->after('integration_instance_id')->constrained();
        });
        Schema::table('amazon_fba_report_customer_returns', function (Blueprint $table) {
            $table->foreignId('amazon_report_id')->after('integration_instance_id')->constrained();
        });
        Schema::table('amazon_fba_report_inventory_ledger', function (Blueprint $table) {
            $table->foreignId('amazon_report_id')->after('integration_instance_id')->constrained();
        });
        Schema::table('amazon_fba_report_removal_orders', function (Blueprint $table) {
            $table->foreignId('amazon_report_id')->after('integration_instance_id')->constrained();
        });
        Schema::table('amazon_fba_report_removal_shipments', function (Blueprint $table) {
            $table->foreignId('amazon_report_id')->after('integration_instance_id')->constrained();
        });
        Schema::table('amazon_fba_report_restock', function (Blueprint $table) {
            $table->foreignId('amazon_report_id')->after('integration_instance_id')->constrained();
        });
        Schema::table('amazon_fba_report_shipments', function (Blueprint $table) {
            $table->foreignId('amazon_report_id')->after('integration_instance_id')->constrained();
        });
    }

    /**
     * Reverse the migrations.
     */
    public function down(): void
    {
        Schema::table('amazon_fba_report_customer_returns', function (Blueprint $table) {
            $table->dropForeignIdFor('amazon_report_id');
        });
        Schema::table('amazon_fba_report_inventory_ledger', function (Blueprint $table) {
            $table->dropForeignIdFor('amazon_report_id');
        });
        Schema::table('amazon_fba_report_removal_orders', function (Blueprint $table) {
            $table->dropForeignIdFor('amazon_report_id');
        });
        Schema::table('amazon_fba_report_removal_shipments', function (Blueprint $table) {
            $table->dropForeignIdFor('amazon_report_id');
        });
        Schema::table('amazon_fba_report_restock', function (Blueprint $table) {
            $table->dropForeignIdFor('amazon_report_id');
        });
        Schema::table('amazon_fba_report_shipments', function (Blueprint $table) {
            $table->dropForeignIdFor('amazon_report_id');
        });
    }
};
