<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     */
    public function up(): void
    {
        Schema::create('amazon_fba_inbound_shipments', function (Blueprint $table) {
            $table->id();
            $table->foreignId('integration_instance_id')->index('integrationInstanceIndex');
            $table->unsignedBigInteger('sku_link_id')->nullable();
            $table->string('sku_link_type')->nullable();
            $table->string('ShipmentId')->storedAs("JSON_UNQUOTE(JSON_EXTRACT(json_object, '$.ShipmentId'))");
            $table->string('ShipmentName')->storedAs("JSON_UNQUOTE(JSON_EXTRACT(json_object, '$.ShipmentName'))");
            $table->string('ShipFromName')->storedAs("JSON_UNQUOTE(JSON_EXTRACT(json_object, '$.ShipFromAddress.Name'))");
            $table->string('DestinationFulfillmentCenterId')->storedAs("JSON_UNQUOTE(JSON_EXTRACT(json_object, '$.DestinationFulfillmentCenterId'))");
            $table->string('ShipmentStatus')->storedAs("JSON_UNQUOTE(JSON_EXTRACT(json_object, '$.ShipmentStatus'))");
            $table->string('LabelPrepType')->storedAs("JSON_UNQUOTE(JSON_EXTRACT(json_object, '$.LabelPrepType'))");
            $table->string('BoxContentsSource')->storedAs("JSON_UNQUOTE(JSON_EXTRACT(json_object, '$.BoxContentsSource'))");
            $table->json('json_object');
            $table->index(['sku_link_id', 'sku_link_type'], 'skuLinkIndex');
            $table->timestamps();
        });
    }

    /**
     * Reverse the migrations.
     */
    public function down(): void
    {
        Schema::dropIfExists('amazon_fba_inbound_shipments');
    }
};
