<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     */
    public function up(): void
    {
        Schema::create('amazon_fulfillment_shipments', function (Blueprint $table) {
            $table->id();
            $table->foreignId('amazon_fulfillment_order_id')->index('fulfillmentOrderIndex');
            $table->string('amazonShipmentId')->storedAs("JSON_UNQUOTE(JSON_EXTRACT(json_object, '$.amazonShipmentId'))");
            $table->string('fulfillmentCenterId')->storedAs("JSON_UNQUOTE(JSON_EXTRACT(json_object, '$.fulfillmentCenterId'))");
            $table->string('fulfillmentShipmentStatus')->storedAs("JSON_UNQUOTE(JSON_EXTRACT(json_object, '$.fulfillmentShipmentStatus'))");
            $table->string('shippingDate')->storedAs("JSON_UNQUOTE(JSON_EXTRACT(json_object, '$.shippingDate'))");
            $table->string('estimatedArrivalDate')->storedAs("JSON_UNQUOTE(JSON_EXTRACT(json_object, '$.estimatedArrivalDate'))");
            $table->string('shippingNotes')->storedAs("JSON_UNQUOTE(JSON_EXTRACT(json_object, '$.shippingNotes'))");
            $table->json('json_object');
            $table->timestamps();
        });
    }

    /**
     * Reverse the migrations.
     */
    public function down(): void
    {
        Schema::dropIfExists('amazon_fulfillment_shipments');
    }
};
