<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     */
    public function up(): void
    {
        Schema::create('amazon_fulfillment_order_items', function (Blueprint $table) {
            $table->id();
            $table->foreignId('amazon_fulfillment_order_id')->index('fulfillmentOrderIndex');
            $table->string('sellerSku');
            $table->string('sellerFulfillmentOrderItemId');
            $table->integer('quantity');
            $table->string('giftMessage');
            $table->string('displayableComment');
            $table->string('fulfillmentNetworkSku');
            $table->string('orderItemDisposition')->storedAs("JSON_UNQUOTE(JSON_EXTRACT(json_object, '$.orderItemDisposition'))");
            $table->integer('cancelledQuantity')->storedAs("JSON_UNQUOTE(JSON_EXTRACT(json_object, '$.cancelledQuantity'))");
            $table->integer('unfulfillableQuantity')->storedAs("JSON_UNQUOTE(JSON_EXTRACT(json_object, '$.unfulfillableQuantity'))");
            $table->string('estimatedShipDate')->storedAs("JSON_UNQUOTE(JSON_EXTRACT(json_object, '$.estimatedShipDate'))");
            $table->string('estimatedArrivalDate')->storedAs("JSON_UNQUOTE(JSON_EXTRACT(json_object, '$.estimatedArrivalDate'))");
            $table->string('perUnitPriceCurrencyCode');
            $table->decimal('perUnitPriceCurrencyValue', 12, 4);
            $table->string('perUnitTaxCurrencyCode');
            $table->decimal('perUnitTaxValue', 12, 4);
            $table->string('perUnitDeclaredValueCurrencyCode');
            $table->decimal('perUnitDeclaredValueValue', 12, 4);
            $table->json('json_object')->nullable();
            $table->timestamps();
        });
    }

    /**
     * Reverse the migrations.
     */
    public function down(): void
    {
        Schema::dropIfExists('amazon_fulfillment_order_items');
    }
};
