<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     */
    public function up(): void
    {
        Schema::create('amazon_fba_report_removal_orders', function (Blueprint $table) {
            $table->id();
            $table->foreignId('integration_instance_id')->index();

            $table->string('request_date')->storedAs("JSON_UNQUOTE(JSON_EXTRACT(json_object, '$.request_date'))");
            $table->string('order_id')->storedAs("JSON_UNQUOTE(JSON_EXTRACT(json_object, '$.order_id'))");
            $table->string('order_type')->storedAs("JSON_UNQUOTE(JSON_EXTRACT(json_object, '$.order_type'))");
            $table->string('order_status')->storedAs("JSON_UNQUOTE(JSON_EXTRACT(json_object, '$.order_status'))");
            $table->string('last_updated_date')->storedAs("JSON_UNQUOTE(JSON_EXTRACT(json_object, '$.last_updated_date'))");
            $table->string('sku')->storedAs("JSON_UNQUOTE(JSON_EXTRACT(json_object, '$.sku'))");
            $table->string('fnsku')->storedAs("JSON_UNQUOTE(JSON_EXTRACT(json_object, '$.fnsku'))");
            $table->string('disposition')->storedAs("JSON_UNQUOTE(JSON_EXTRACT(json_object, '$.disposition'))");
            $table->integer('requested_quantity')->storedAs("JSON_UNQUOTE(JSON_EXTRACT(json_object, '$.requested_quantity'))");
            $table->integer('cancelled_quantity')->storedAs("JSON_UNQUOTE(JSON_EXTRACT(json_object, '$.cancelled_quantity'))");
            $table->integer('disposed_quantity')->storedAs("JSON_UNQUOTE(JSON_EXTRACT(json_object, '$.disposed_quantity'))");
            $table->integer('shipped_quantity')->storedAs("JSON_UNQUOTE(JSON_EXTRACT(json_object, '$.shipped_quantity'))");
            $table->integer('in_process_quantity')->storedAs("JSON_UNQUOTE(JSON_EXTRACT(json_object, '$.in_process_quantity'))");
            $table->float('removal_fee', 12, 4)->storedAs("JSON_UNQUOTE(JSON_EXTRACT(json_object, '$.removal_fee'))");
            $table->string('currency')->storedAs("JSON_UNQUOTE(JSON_EXTRACT(json_object, '$.currency'))");
            $table->json('json_object');
            $table->timestamps();
        });
    }

    /**
     * Reverse the migrations.
     */
    public function down(): void
    {
        Schema::dropIfExists('amazon_fba_report_removal_orders');
    }
};
