<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     */
    public function up(): void
    {
        Schema::create('amazon_financial_event_groups', function (Blueprint $table) {
            $table->id();
            $table->foreignId('integration_instance_id');
            $table->string('FinancialEventGroupId')->storedAs("JSON_UNQUOTE(JSON_EXTRACT(json_object, '$.FinancialEventGroupId'))");
            $table->string('ProcessingStatus')->storedAs("JSON_UNQUOTE(JSON_EXTRACT(json_object, '$.ProcessingStatus'))");
            $table->string('FundTransferStatus')->storedAs("JSON_UNQUOTE(JSON_EXTRACT(json_object, '$.FundTransferStatus'))");
            $table->string('OriginalTotalCurrencyCode')->storedAs("JSON_UNQUOTE(JSON_EXTRACT(json_object, '$.OriginalTotal.CurrencyCode'))");
            $table->string('OriginalTotalCurrencyAmount')->storedAs("JSON_UNQUOTE(JSON_EXTRACT(json_object, '$.OriginalTotal.CurrencyAmount'))");
            $table->string('ConvertedTotalCurrencyCode')->storedAs("JSON_UNQUOTE(JSON_EXTRACT(json_object, '$.ConvertedTotal.CurrencyCode'))");
            $table->string('ConvertedTotalCurrencyAmount')->storedAs("JSON_UNQUOTE(JSON_EXTRACT(json_object, '$.ConvertedTotal.CurrencyAmount'))");
            $table->string('FundTransferDate')->storedAs("JSON_UNQUOTE(JSON_EXTRACT(json_object, '$.FundTransferDate'))");
            $table->string('TraceId')->storedAs("JSON_UNQUOTE(JSON_EXTRACT(json_object, '$.TraceId'))");
            $table->string('AccountTail')->storedAs("JSON_UNQUOTE(JSON_EXTRACT(json_object, '$.AccountTail'))");
            $table->string('BeginningBalanceCurrencyCode')->storedAs("JSON_UNQUOTE(JSON_EXTRACT(json_object, '$.BeginningBalance.CurrencyCode'))");
            $table->string('BeginningBalanceCurrencyAmount')->storedAs("JSON_UNQUOTE(JSON_EXTRACT(json_object, '$.BeginningBalance.CurrencyAmount'))");
            $table->string('FinancialEventGroupStart')->storedAs("JSON_UNQUOTE(JSON_EXTRACT(json_object, '$.FinancialEventGroupStart'))");
            $table->string('FinancialEventGroupEnd')->storedAs("JSON_UNQUOTE(JSON_EXTRACT(json_object, '$.FinancialEventGroupEnd'))");
            $table->json('json_object');
            $table->timestamps();
        });
    }

    /**
     * Reverse the migrations.
     */
    public function down(): void
    {
        Schema::dropIfExists('amazon_financial_event_groups');
    }
};
