<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     */
    public function up(): void
    {
        Schema::create('amazon_fba_report_restock', function (Blueprint $table) {
            $table->id();
            $table->foreignId('integration_instance_id')->index();
            $table->string('country')->storedAs("JSON_UNQUOTE(JSON_EXTRACT(json_object, '$.country'))");
            $table->string('product_name')->storedAs("JSON_UNQUOTE(JSON_EXTRACT(json_object, '$.product_name'))");
            $table->string('fnsku')->storedAs("JSON_UNQUOTE(JSON_EXTRACT(json_object, '$.fnsku'))");
            $table->string('merchant_sku')->storedAs("JSON_UNQUOTE(JSON_EXTRACT(json_object, '$.merchant_sku'))");
            $table->string('asin')->storedAs("JSON_UNQUOTE(JSON_EXTRACT(json_object, '$.asin'))");
            $table->string('condition')->storedAs("JSON_UNQUOTE(JSON_EXTRACT(json_object, '$.condition'))");
            $table->string('supplier')->storedAs("JSON_UNQUOTE(JSON_EXTRACT(json_object, '$.supplier'))");
            $table->string('supplier_part_no')->storedAs("JSON_UNQUOTE(JSON_EXTRACT(json_object, '$.supplier_part_no'))");
            $table->string('currency_code')->storedAs("JSON_UNQUOTE(JSON_EXTRACT(json_object, '$.currency_code'))");
            $table->float('price', 12, 4)->storedAs("JSON_UNQUOTE(JSON_EXTRACT(json_object, '$.price'))");
            $table->float('sales_last_30_days', 12, 4)->storedAs("JSON_UNQUOTE(JSON_EXTRACT(json_object, '$.sales_last_30_days'))");
            $table->integer('units_sold_last_30_days')->storedAs("JSON_UNQUOTE(JSON_EXTRACT(json_object, '$.units_sold_last_30_days'))");
            $table->integer('total_units')->storedAs("JSON_UNQUOTE(JSON_EXTRACT(json_object, '$.total_units'))");
            $table->integer('inbound')->storedAs("JSON_UNQUOTE(JSON_EXTRACT(json_object, '$.inbound'))");
            $table->integer('available')->storedAs("JSON_UNQUOTE(JSON_EXTRACT(json_object, '$.available'))");
            $table->integer('fc_transfer')->storedAs("JSON_UNQUOTE(JSON_EXTRACT(json_object, '$.fc_transfer'))");
            $table->integer('fc_processing')->storedAs("JSON_UNQUOTE(JSON_EXTRACT(json_object, '$.fc_processing'))");
            $table->integer('customer_order')->storedAs("JSON_UNQUOTE(JSON_EXTRACT(json_object, '$.customer_order'))");
            $table->integer('unfulfillable')->storedAs("JSON_UNQUOTE(JSON_EXTRACT(json_object, '$.unfulfillable'))");
            $table->integer('working')->storedAs("JSON_UNQUOTE(JSON_EXTRACT(json_object, '$.working'))");
            $table->integer('shipped')->storedAs("JSON_UNQUOTE(JSON_EXTRACT(json_object, '$.shipped'))");
            $table->integer('receiving')->storedAs("JSON_UNQUOTE(JSON_EXTRACT(json_object, '$.receiving'))");
            $table->string('fulfilled_by')->storedAs("JSON_UNQUOTE(JSON_EXTRACT(json_object, '$.fulfilled_by'))");
            $table->string('total_days_of_supply')->storedAs("JSON_UNQUOTE(JSON_EXTRACT(json_object, '$.total_days_of_supply'))");
            $table->string('days_of_supply_at_amazon_fulfillment_network')->storedAs("JSON_UNQUOTE(JSON_EXTRACT(json_object, '$.days_of_supply_at_amazon_fulfillment_network'))");
            $table->string('alert')->storedAs("JSON_UNQUOTE(JSON_EXTRACT(json_object, '$.alert'))");
            $table->integer('recommended_replenishment_qty')->storedAs("JSON_UNQUOTE(JSON_EXTRACT(json_object, '$.recommended_replenishment_qty'))");
            $table->string('recommended_ship_date')->storedAs("JSON_UNQUOTE(JSON_EXTRACT(json_object, '$.recommended_ship_date'))");
            $table->json('json_object');
            $table->timestamps();
        });
    }

    /**
     * Reverse the migrations.
     */
    public function down(): void
    {
        Schema::dropIfExists('amazon_fba_report_restock');
    }
};
