<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     */
    public function up(): void
    {
        Schema::create('amazon_fba_report_inventory_ledger', function (Blueprint $table) {
            $table->id();
            $table->foreignId('integration_instance_id')->index();
            $table->string('date')->storedAs("JSON_UNQUOTE(JSON_EXTRACT(json_object, '$.date'))");
            $table->string('fnsku')->storedAs("JSON_UNQUOTE(JSON_EXTRACT(json_object, '$.fnsku'))");
            $table->string('asin')->storedAs("JSON_UNQUOTE(JSON_EXTRACT(json_object, '$.asin'))");
            $table->string('msku')->storedAs("JSON_UNQUOTE(JSON_EXTRACT(json_object, '$.msku'))");
            $table->string('title')->storedAs("JSON_UNQUOTE(JSON_EXTRACT(json_object, '$.title'))");
            $table->string('event_type')->storedAs("JSON_UNQUOTE(JSON_EXTRACT(json_object, '$.event_type'))");
            $table->string('reference_id')->storedAs("JSON_UNQUOTE(JSON_EXTRACT(json_object, '$.reference_id'))");
            $table->string('quantity')->storedAs("JSON_UNQUOTE(JSON_EXTRACT(json_object, '$.quantity'))");
            $table->string('fulfillment_center')->storedAs("JSON_UNQUOTE(JSON_EXTRACT(json_object, '$.fulfillment_center'))");
            $table->string('disposition')->storedAs("JSON_UNQUOTE(JSON_EXTRACT(json_object, '$.disposition'))");
            $table->string('reason')->storedAs("JSON_UNQUOTE(JSON_EXTRACT(json_object, '$.reason'))");
            $table->string('country')->storedAs("JSON_UNQUOTE(JSON_EXTRACT(json_object, '$.country'))");
            $table->string('reconciled_quantity')->storedAs("JSON_UNQUOTE(JSON_EXTRACT(json_object, '$.reconciled_quantity'))");
            $table->string('unreconciled_quantity')->storedAs("JSON_UNQUOTE(JSON_EXTRACT(json_object, '$.unreconciled_quantity'))");
            $table->json('json_object');
            $table->index(['integration_instance_id', 'msku'], 'msku_index');
            $table->timestamps();
        });
    }

    /**
     * Reverse the migrations.
     */
    public function down(): void
    {
        Schema::dropIfExists('amazon_fba_report_inventory_ledger');
    }
};
