<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     */
    public function up(): void
    {
        Schema::create('amazon_products', function (Blueprint $table) {
            $table->id();

            $table->foreignId('integration_instance_id')->index()->constrained();
            $table->string('item_name')->storedAs('JSON_UNQUOTE(JSON_EXTRACT(json_object, "$.item_name"))');
            $table->string('seller_sku')->index()->storedAs('JSON_UNQUOTE(JSON_EXTRACT(json_object, "$.seller_sku"))');
            $table->decimal('price', 12, 4)->storedAs('JSON_UNQUOTE(JSON_EXTRACT(json_object, "$.price"))');
            $table->unsignedInteger('quantity')->storedAs('JSON_UNQUOTE(JSON_EXTRACT(json_object, "$.quantity"))');
            $table->string('image_url')->storedAs('JSON_UNQUOTE(JSON_EXTRACT(json_object, "$.image_url"))');
            $table->string('product_id_type')->storedAs('JSON_UNQUOTE(JSON_EXTRACT(json_object, "$.product_id_type"))');
            $table->string('item_note')->storedAs('JSON_UNQUOTE(JSON_EXTRACT(json_object, "$.item_note"))');
            $table->string('item_condition')->storedAs('JSON_UNQUOTE(JSON_EXTRACT(json_object, "$.item_condition"))');
            $table->string('asin1')->index()->storedAs('JSON_UNQUOTE(JSON_EXTRACT(json_object, "$.asin1"))');
            $table->string('product_id')->storedAs('JSON_UNQUOTE(JSON_EXTRACT(json_object, "$.product_id"))');
            $table->string('fulfillment_channel')->storedAs('JSON_UNQUOTE(JSON_EXTRACT(json_object, "$.fulfillment_channel"))');
            $table->string('merchant_shipping_group')->storedAs('JSON_UNQUOTE(JSON_EXTRACT(json_object, "$.merchant_shipping_group"))');
            $table->string('status')->storedAs('JSON_UNQUOTE(JSON_EXTRACT(json_object, "$.status"))');
            $table->json('json_object');

            $table->unique(['integration_instance_id', 'seller_sku']);

            $table->timestamps();
        });
    }

    /**
     * Reverse the migrations.
     */
    public function down(): void
    {
        Schema::dropIfExists('amazon_products');
    }
};
