<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     */
    public function up(): void
    {
        Schema::create('amazon_orders', function (Blueprint $table) {
            $table->id();
            $table->foreignId('integration_instance_id')->index()->constrained();
            $table->string('AmazonOrderId')->storedAs("JSON_UNQUOTE(json_extract(json_object,'$.AmazonOrderId'))")->index();
            $table->string('SellerOrderId')->storedAs("JSON_UNQUOTE(json_extract(json_object,'$.SellerOrderId'))");
            $table->string('PurchaseDate')->storedAs("JSON_UNQUOTE(json_extract(json_object,'$.PurchaseDate'))");
            $table->string('LastUpdateDate')->storedAs("JSON_UNQUOTE(json_extract(json_object,'$.LastUpdateDate'))");
            $table->string('OrderStatus')->storedAs("JSON_UNQUOTE(json_extract(json_object,'$.OrderStatus'))");
            $table->string('FulfillmentChannel')->storedAs("JSON_UNQUOTE(json_extract(json_object,'$.FulfillmentChannel'))");
            $table->string('SalesChannel')->storedAs("JSON_UNQUOTE(json_extract(json_object,'$.SalesChannel'))");
            $table->string('ShipServiceLevel')->storedAs("JSON_UNQUOTE(json_extract(json_object,'$.ShipServiceLevel'))");
            $table->string('OrderCurrency')->storedAs("JSON_UNQUOTE(json_extract(json_object,'$.OrderTotal.CurrencyCode'))");
            $table->string('OrderTotal')->storedAs("JSON_UNQUOTE(json_extract(json_object,'$.OrderTotal.Amount'))");
            $table->string('NumberOfItemsShipped')->storedAs("JSON_UNQUOTE(json_extract(json_object,'$.NumberOfItemsShipped'))");
            $table->string('PaymentMethod')->storedAs("JSON_UNQUOTE(json_extract(json_object,'$.PaymentMethod'))");
            $table->string('MarketplaceId')->storedAs("JSON_UNQUOTE(json_extract(json_object,'$.MarketplaceId'))");
            $table->text('BuyerName')->storedAs("JSON_UNQUOTE(json_extract(json_object,'$.BuyerInfo.BuyerName'))");
            $table->text('BuyerEmail')->storedAs("JSON_UNQUOTE(json_extract(json_object,'$.BuyerInfo.BuyerEmail'))");
            $table->string('PaymentMethodDetails')->storedAs("JSON_UNQUOTE(json_extract(json_object,'$.PaymentMethodDetails'))");
            $table->string('ShipmentServiceLevelCategory')->storedAs("JSON_UNQUOTE(json_extract(json_object,'$.ShipmentServiceLevelCategory'))");
            $table->string('OrderType')->storedAs("JSON_UNQUOTE(json_extract(json_object,'$.OrderType'))");
            $table->string('EarliestShipDate')->storedAs("JSON_UNQUOTE(json_extract(json_object,'$.EarliestShipDate'))");
            $table->string('LatestShipDate')->storedAs("JSON_UNQUOTE(json_extract(json_object,'$.LatestShipDate'))");
            $table->string('EarliestDeliveryDate')->storedAs("JSON_UNQUOTE(json_extract(json_object,'$.EarliestDeliveryDate'))");
            $table->string('LatestDeliveryDate')->storedAs("JSON_UNQUOTE(json_extract(json_object,'$.LatestDeliveryDate'))");
            $table->string('IsBusinessOrder')->storedAs("JSON_UNQUOTE(json_extract(json_object,'$.IsBusinessOrder'))");
            $table->string('IsPrime')->storedAs("JSON_UNQUOTE(json_extract(json_object,'$.IsPrime'))");
            $table->string('IsPremiumOrder')->storedAs("JSON_UNQUOTE(json_extract(json_object,'$.IsPremiumOrder'))");
            $table->string('ReplacedOrderId')->storedAs("JSON_UNQUOTE(json_extract(json_object,'$.ReplacedOrderId'))");
            $table->string('IsReplacementOrder')->storedAs("JSON_UNQUOTE(json_extract(json_object,'$.IsReplacementOrder'))");
            $table->json('json_object');
            $table->unique(['integration_instance_id', 'AmazonOrderId']);
            $table->json('errors')->nullable();
            $table->dateTime('archived_at')->nullable();
            $table->dateTime('canceled_at')->nullable();
            $table->timestamps();
        });
    }

    /**
     * Reverse the migrations.
     */
    public function down(): void
    {
        Schema::dropIfExists('amazon_orders');
    }
};
