<?php

namespace Modules\Amazon\Database\Factories;

use Illuminate\Database\Eloquent\Factories\Factory;
use Illuminate\Support\Carbon;
use Modules\Amazon\Entities\AmazonIntegrationInstance;
use Modules\Amazon\Entities\AmazonReportRequest;
use Modules\Amazon\Enums\Entities\AmazonReportTypeEnum;

class AmazonReportRequestFactory extends Factory
{
    protected $model = AmazonReportRequest::class;

    public function definition(): array
    {
        return [
            'reportType' => $this->faker->randomElement(AmazonReportTypeEnum::cases()),
            'dataStartTime' => Carbon::now(),
            'dataEndTime' => Carbon::now(),
            'options' => $this->faker->words(),
            'marketplaceIds' => $this->faker->words(),
            'created_at' => Carbon::now(),
            'updated_at' => Carbon::now(),
            'integration_instance_id' => AmazonIntegrationInstance::factory(),
        ];
    }
}
