<?php

namespace Modules\Amazon\Database\Factories;

use Illuminate\Database\Eloquent\Factories\Factory;
use Modules\Amazon\Entities\AmazonIntegrationInstance;
use Modules\Amazon\Entities\AmazonProduct;

class AmazonProductFactory extends Factory
{
    /**
     * The name of the factory's corresponding model.
     *
     * @var string
     */
    protected $model = AmazonProduct::class;

    /**
     * Define the model's default state.
     */
    public function definition(): array
    {
        /** @var AmazonIntegrationInstance $amazonIntegrationInstance */
        $amazonIntegrationInstance = AmazonIntegrationInstance::query()->first();

        return [
            'integration_instance_id' => $amazonIntegrationInstance->id,
            // 'seller_sku' => $this->faker->ean13(),
            // 'fulfillment_channel' => 'AMAZON_NA',
            'json_object' => [
                'item_name' => $this->faker->name(),
                'item_description' => $this->faker->name(),
                'listing_id' => $this->faker->name(),
                'seller_sku' => $this->faker->ean13(),
                'price' => $this->faker->randomFloat(1, 0, 100),
                'quantity' => $this->faker->randomNumber(),
                'open_date' => '2018-06-18 14:32:03 PDT',
                'image_url' => '',
                'item_is_marketplace' => 'y',
                'product_id_type' => '',
                'zshop_shipping_fee' => '',
                'item_note' => '',
                'item_condition' => '',
                'zshop_category1' => '',
                'zshop_browse_path' => '',
                'asin1' => $this->faker->ean13(),
                'asin2' => '',
                'asin3' => '',
                'will_ship_internationally' => '',
                'expedited_shipping' => '',
                'zshop_boldface' => '',
                'product_id' => $this->faker->unique()->numberBetween(),
                'bid_for_featured_placement' => '',
                'add_delete' => '',
                'pending_quantity' => '',
                'fulfillment_channel' => 'AMAZON_NA',
                'merchant_shipping_group' => '',
                'status' => 'Active',
            ],
            'was_catalog_data_sync_attempted' => true,
        ];
    }
}
