<?php

namespace Modules\Amazon\Database\Factories;

use Illuminate\Database\Eloquent\Factories\Factory;
use Modules\Amazon\Entities\AmazonOrder;
use Modules\Amazon\Entities\AmazonOrderItem;
use Modules\Amazon\Entities\AmazonProduct;

class AmazonOrderItemFactory extends Factory
{
    /**
     * The name of the factory's corresponding model.
     *
     * @var string
     */
    protected $model = AmazonOrderItem::class;

    /**
     * Define the model's default state.
     */
    public function definition(): array
    {
        $quantityOrdered = $this->faker->numberBetween(1, 10);

        // Get a random AmazonProduct
        $amazonProduct = AmazonProduct::inRandomOrder()->firstOr(function () {
            return AmazonProduct::factory()->create();
        })
            ->refresh();

        return [
            'amazon_order_id' => AmazonOrder::factory(),
            'json_object' => [
                'ASIN' => $this->faker->word(),
                'SellerSKU' => $amazonProduct->seller_sku,
                'OrderItemId' => $this->faker->unique()->numberBetween(),
                'Title' => $this->faker->word(),
                'QuantityOrdered' => $quantityOrdered,
                'QuantityShipped' => $this->faker->numberBetween(1, $quantityOrdered),
                'ItemPrice' => [
                    'CurrencyCode' => 'USD',
                    'Amount' => $this->faker->randomFloat(2, 1, 100),
                ],
                'ShippingPrice' => [
                    'CurrencyCode' => 'USD',
                    'Amount' => $this->faker->randomFloat(2, 1, 10),
                ],
            ],
        ];
    }
}
