<?php

namespace Modules\Amazon\Database\Factories;

use Illuminate\Database\Eloquent\Factories\Factory;
use Illuminate\Support\Carbon;
use Modules\Amazon\Entities\AmazonIntegrationInstance;
use Modules\Amazon\Entities\AmazonNewFbaInboundPlan;
use Modules\Amazon\Entities\AmazonNewFbaInboundShipment;
use Modules\Amazon\Enums\Entities\AmazonInboundDestinationTypeEnum;
use Modules\Amazon\Enums\Entities\AmazonNewFbaInboundShipmentStatusEnum;

class AmazonNewFbaInboundShipmentFactory extends Factory
{
    protected $model = AmazonNewFbaInboundShipment::class;

    public function definition(): array
    {
        /** @var AmazonIntegrationInstance $amazonIntegrationInstance */
        $amazonIntegrationInstance = AmazonIntegrationInstance::query()->first();

        return [
            'amazon_new_fba_inbound_plan_id' => AmazonNewFbaInboundPlan::factory(),
            'integration_instance_id' => $amazonIntegrationInstance->id,
            'json_object' => [
                'name' => $this->faker->name(),
                'sourceName' => $this->faker->name(),
                'shipmentId' => $this->faker->word(),
                'status' => $this->faker->randomElement(AmazonNewFbaInboundShipmentStatusEnum::values()),
                'amazonReferenceId' => $this->faker->word(),
                'shipmentConfirmationId' => $this->faker->word(),
                'destination' => $this->faker->words(),
                'destinationCountry' => $this->faker->countryCode(),
                'destinationWarehouse' => $this->faker->word(),
                'destinationType' => $this->faker->randomElement(AmazonInboundDestinationTypeEnum::values()),
                'source' => $this->faker->words(),
                'selectedTransportationOptionId' => $this->faker->word(),
                'placementOptionId' => $this->faker->word(),
            ],
            'created_at' => Carbon::now(),
            'updated_at' => Carbon::now(),
        ];
    }
}
