<?php

namespace Modules\Amazon\Database\Factories;

use Illuminate\Database\Eloquent\Factories\Factory;
use Illuminate\Support\Carbon;
use Modules\Amazon\Entities\AmazonNewFbaInboundPlan;
use Modules\Amazon\Entities\AmazonNewFbaInboundPlanItem;

class AmazonNewFbaInboundPlanItemFactory extends Factory
{
    protected $model = AmazonNewFbaInboundPlanItem::class;

    public function definition(): array
    {
        return [
            'amazon_new_fba_inbound_plan_id' => AmazonNewFbaInboundPlan::factory(),
            'json_object' => [
                'labelOwner' => $this->faker->word(),
                'msku' => $this->faker->word(),
                'quantity' => $this->faker->word(),
                'fnsku' => $this->faker->word(),
                'asin' => $this->faker->word(),
                'prepInstructions' => $this->faker->words(),
            ],
            'created_at' => Carbon::now(),
            'updated_at' => Carbon::now(),
        ];
    }
}
