<?php

namespace Modules\Amazon\Database\Factories;

use App\Models\InventoryAdjustment;
use Illuminate\Database\Eloquent\Factories\Factory;
use Illuminate\Support\Carbon;
use Modules\Amazon\Entities\AmazonLedgerSummaryAdjustment;
use Modules\Amazon\Enums\Entities\AmazonLedgerSummaryAdjustmentTypeEnum;

class AmazonLedgerSummaryAdjustmentFactory extends Factory
{
    protected $model = AmazonLedgerSummaryAdjustment::class;

    public function definition(): array
    {
        return [
            'amazon_fba_report_inventory_ledger_summary_id' => $this->faker->randomNumber(),
            'type' => $this->faker->randomElement(AmazonLedgerSummaryAdjustmentTypeEnum::cases()),
            'inventory_adjustment_id' => InventoryAdjustment::factory(),
            'created_at' => Carbon::now(),
            'updated_at' => Carbon::now(),
        ];
    }
}
