<?php

namespace Modules\Amazon\Database\Factories;

use App\Models\Integration;
use Illuminate\Database\Eloquent\Factories\Factory;
use Modules\Amazon\Entities\AmazonIntegrationInstance;

class AmazonIntegrationInstanceFactory extends Factory
{
    /**
     * The name of the factory's corresponding model.
     *
     * @var string
     */
    protected $model = AmazonIntegrationInstance::class;

    /**
     * Define the model's default state.
     */
    public function definition(): array
    {
        /** @var Integration $integration */
        $integration = Integration::query()->firstOrCreate(
            ['name' => Integration::NAME_AMAZON_US],
            ['integration_type' => Integration::TYPE_SALES_CHANNEL]
        );

        $startDate = now()->subYears(2)->toDateTimeString();

        return [
            'integration_id' => $integration->id,
            'name' => 'Amazon US',
            'country' => 'NA',
            'connection_settings' => [
                'refresh_token' => $this->faker->sentence(10),
            ],
            'integration_settings' => [
                'start_date' => $startDate,
                'fba_inventory_tracking_start_date' => $startDate,
                'marketplaceParticipations' => [
                    [
                        "marketplace" => [
                            "id" => "A1AM78C64UM0Y8",
                            "countryCode" => "MX",
                            "name" => "Amazon.com.mx",
                            "defaultCurrencyCode" => "MXN",
                            "defaultLanguageCode" => "es_MX",
                            "domainName" => "www.amazon.com.mx",
                        ],
                        "participation" => [
                            "isParticipating" => true,
                            "hasSuspendedListings" => false,
                        ],
                    ],
                    [
                        "marketplace" => [
                            "id" => "A1MQXOICRS2Z7M",
                            "countryCode" => "CA",
                            "name" => "SI CA Prod Marketplace",
                            "defaultCurrencyCode" => "CAD",
                            "defaultLanguageCode" => "en_CA",
                            "domainName" => "siprod.stores.amazon.ca",
                        ],
                        "participation" => [
                            "isParticipating" => true,
                            "hasSuspendedListings" => false,
                        ],
                    ],
                    [
                        "marketplace" => [
                            "id" => "A2EUQ1WTGCTBG2",
                            "countryCode" => "CA",
                            "name" => "Amazon.ca",
                            "defaultCurrencyCode" => "CAD",
                            "defaultLanguageCode" => "en_CA",
                            "domainName" => "www.amazon.ca",
                        ],
                        "participation" => [
                            "isParticipating" => true,
                            "hasSuspendedListings" => false,
                        ],
                    ],
                    [
                        "marketplace" => [
                            "id" => "A2Q3Y263D00KWC",
                            "countryCode" => "BR",
                            "name" => "Amazon.com.br",
                            "defaultCurrencyCode" => "BRL",
                            "defaultLanguageCode" => "pt_BR",
                            "domainName" => "www.amazon.com.br",
                        ],
                        "participation" => [
                            "isParticipating" => true,
                            "hasSuspendedListings" => false,
                        ],
                    ],
                    [
                        "marketplace" => [
                            "id" => "A2ZV50J4W1RKNI",
                            "countryCode" => "US",
                            "name" => "Non-Amazon",
                            "defaultCurrencyCode" => "USD",
                            "defaultLanguageCode" => "en_US",
                            "domainName" => "sim1.stores.amazon.com",
                        ],
                        "participation" => [
                            "isParticipating" => true,
                            "hasSuspendedListings" => false,
                        ],
                    ],
                    [
                        "marketplace" => [
                            "id" => "A3BXB0YN3XH17H",
                            "countryCode" => "US",
                            "name" => "Amazon Pay Sandbox",
                            "defaultCurrencyCode" => "USD",
                            "defaultLanguageCode" => "en_US",
                            "domainName" => "apa-sandbox.amazon.com",
                        ],
                        "participation" => [
                            "isParticipating" => true,
                            "hasSuspendedListings" => false,
                        ],
                    ],
                    [
                        "marketplace" => [
                            "id" => "A3H6HPSLHAK3XG",
                            "countryCode" => "MX",
                            "name" => "Non-Amazon",
                            "defaultCurrencyCode" => "MXN",
                            "defaultLanguageCode" => "es_MX",
                            "domainName" => "sidevo.stores.amazon.mx",
                        ],
                        "participation" => [
                            "isParticipating" => true,
                            "hasSuspendedListings" => false,
                        ],
                    ],
                    [
                        "marketplace" => [
                            "id" => "A6W85IYQ5WB1C",
                            "countryCode" => "US",
                            "name" => "IBA",
                            "defaultCurrencyCode" => "USD",
                            "defaultLanguageCode" => "en_US",
                            "domainName" => "iba.login.amazon.com",
                        ],
                        "participation" => [
                            "isParticipating" => true,
                            "hasSuspendedListings" => false,
                        ],
                    ],
                    [
                        "marketplace" => [
                            "id" => "AGWSWK15IEJJ7",
                            "countryCode" => "US",
                            "name" => "Amazon Pay",
                            "defaultCurrencyCode" => "USD",
                            "defaultLanguageCode" => "en_US",
                            "domainName" => "apa.amazon.com",
                        ],
                        "participation" => [
                            "isParticipating" => true,
                            "hasSuspendedListings" => false,
                        ],
                    ],
                    [
                        "marketplace" => [
                            "id" => "AHRY1CZE9ZY4H",
                            "countryCode" => "US",
                            "name" => "Amazon.com Invoicing Shadow Marketplace",
                            "defaultCurrencyCode" => "USD",
                            "defaultLanguageCode" => "en_US",
                            "domainName" => "invoicing-shadow-marketplace.amazon.com",
                        ],
                        "participation" => [
                            "isParticipating" => true,
                            "hasSuspendedListings" => false,
                        ],
                    ],
                    [
                        "marketplace" => [
                            "id" => "ATVPDKIKX0DER",
                            "countryCode" => "US",
                            "name" => "Amazon.com",
                            "defaultCurrencyCode" => "USD",
                            "defaultLanguageCode" => "en_US",
                            "domainName" => "www.amazon.com",
                        ],
                        "participation" => [
                            "isParticipating" => true,
                            "hasSuspendedListings" => false,
                        ],
                    ],
                ],
                'catalogMarketplaceId' => 'ATVPDKIKX0DER',
            ],
        ];
    }
}
